/*
 * Decompiled with CFR 0.152.
 */
package dev.yumi.commons.event;

import dev.yumi.commons.collections.toposort.NodeSorting;
import dev.yumi.commons.event.EventPhaseData;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class Event<I extends Comparable<? super I>, T> {
    private final Class<? super T> type;
    private final I defaultPhaseId;
    private final Function<T[], T> invokerFactory;
    private final Lock lock = new ReentrantLock();
    private volatile T invoker;
    private T[] listeners;
    private final Map<I, EventPhaseData<I, T>> phases = new LinkedHashMap<I, EventPhaseData<I, T>>();
    private final List<EventPhaseData<I, T>> sortedPhases = new ArrayList<EventPhaseData<I, T>>();

    protected Event(@NotNull Class<? super T> type, @NotNull I defaultPhaseId, @NotNull Function<T[], T> invokerFactory) {
        Objects.requireNonNull(type, "The class specifying the type of T in the event cannot be null.");
        Objects.requireNonNull(defaultPhaseId, "The default phase identifier of the event cannot be null.");
        Objects.requireNonNull(invokerFactory, "The function to generate the invoker implementation for T cannot be null.");
        this.type = type;
        this.defaultPhaseId = defaultPhaseId;
        this.invokerFactory = invokerFactory;
        this.listeners = (Object[])Array.newInstance(type, 0);
        this.update();
    }

    @Contract(pure=true)
    @NotNull
    public Class<? super T> getType() {
        return this.type;
    }

    @Contract(pure=true)
    @NotNull
    public I getDefaultPhaseId() {
        return this.defaultPhaseId;
    }

    public void register(@NotNull T listener) {
        this.register(this.defaultPhaseId, listener);
    }

    public void register(@NotNull I phaseIdentifier, @NotNull T listener) {
        Objects.requireNonNull(phaseIdentifier, "Cannot register a listener for a null phase.");
        Objects.requireNonNull(listener, "Cannot register a null listener.");
        this.lock.lock();
        try {
            this.getOrCreatePhase(phaseIdentifier, true).addListener(listener);
            this.rebuildInvoker(this.listeners.length + 1);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPhaseOrdering(@NotNull I firstPhase, @NotNull I secondPhase) {
        Objects.requireNonNull(firstPhase, "Tried to order a null phase.");
        Objects.requireNonNull(secondPhase, "Tried to order a null phase.");
        if (firstPhase.equals(secondPhase)) {
            throw new IllegalArgumentException("Cannot make a phase depend on itself.");
        }
        this.lock.lock();
        try {
            EventPhaseData<I, T> first = this.getOrCreatePhase(firstPhase, false);
            EventPhaseData<I, T> second = this.getOrCreatePhase(secondPhase, false);
            EventPhaseData.link(first, second);
            NodeSorting.sort(this.sortedPhases, "event phases");
            this.rebuildInvoker(this.listeners.length);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Contract(pure=true)
    @NotNull
    public T invoker() {
        return this.invoker;
    }

    private EventPhaseData<I, T> getOrCreatePhase(I id, boolean sortIfCreate) {
        EventPhaseData<I, Object> phase = this.phases.get(id);
        if (phase == null) {
            phase = new EventPhaseData<I, T>(id, this.type);
            this.phases.put(id, phase);
            this.sortedPhases.add(phase);
            if (sortIfCreate) {
                NodeSorting.sort(this.sortedPhases, "event phases");
            }
        }
        return phase;
    }

    private void rebuildInvoker(int newLength) {
        if (this.sortedPhases.size() == 1) {
            this.listeners = this.sortedPhases.get((int)0).listeners;
        } else {
            Object[] newListeners = (Object[])Array.newInstance(this.type, newLength);
            int nextStart = 0;
            for (EventPhaseData<I, T> phase : this.sortedPhases) {
                int phaseListenersCount = phase.listeners.length;
                System.arraycopy(phase.listeners, 0, newListeners, nextStart, phaseListenersCount);
                nextStart += phaseListenersCount;
            }
            this.listeners = newListeners;
        }
        this.update();
    }

    private void update() {
        this.invoker = this.invokerFactory.apply((T[][])Arrays.copyOf(this.listeners, this.listeners.length));
    }

    public String toString() {
        return "Event{type=" + this.type + ", defaultPhaseId=" + this.defaultPhaseId + ", invoker=" + this.invoker + ", listeners=" + Arrays.toString(this.listeners) + ", phases=" + this.phases + ", sortedPhases=" + this.sortedPhases + "}";
    }
}

